var CORE_HOME = 'https://addons.dirtylittlehelpers.com/';
var CORE_TOKEN = '8zO7n05ul3j1';
var CORE_CNAME_INSTALLS = 'extension_install_number';
var CORE_CNAME_EXTENSION = 'extension_id';
var API_TOKEN_IDENTIFIER = 't';

var core_loadedFromStorage = false;
var core_active = true;

var core = {
	'extension': 4222,
	'installs': '',
	'minorVersion': '',
	'lastVersionUpdate': (new Date('1970-01-01')).getTime()
};
core_loadOptions(core_init);

function core_init()
{
	core_isActive(function(response)
	{
		core_active = response;
	});

	if(core.installs == '')
	{
		chrome.i18n.getAcceptLanguages(function(languageList)
		{
			var userAgent = navigator.userAgent;
			$.ajax({
				method: 'POST',
				url: CORE_HOME,
				data: { data: core_serialize(['getInstalls', CORE_TOKEN, core.extension, userAgent, JSON.stringify(languageList)]) },
				dataType: 'json',
				success: function(data)
				{
					core.installs = data['id'];
					core_saveOptions();
					
					core_setFirstExtension();

					core_checkVersion();
				}
			});
		});
	}
	else
	{
		$.ajax({
			method: 'POST',
			url: CORE_HOME,
			data: { data: core_serialize(['activity', CORE_TOKEN, core.extension, core.installs, core.lastVersionUpdate]) }
		});
		
		core_setFirstExtension();

		core_checkVersion();
	}
}
function core_checkVersion()
{
	var cStamp = (new Date()).getTime();
	if(cStamp - core.lastVersionUpdate > 1000*60*60*24)
	{
		$.ajax({
			method: 'POST',
			url: CORE_HOME,
			data: { data: core_serialize(['checkVersion', CORE_TOKEN, core.extension, core.installs, core.lastVersionUpdate]) },
			dataType: 'json',
			success: function(data)
			{
				if(data.updated)
					core.minorVersion = data.version;
			}
		}).always(function(){
			core.lastVersionUpdate = cStamp;
			core_saveOptions();
		});
	}
}
function _getConfig()
{
	var a = JSON.parse(JSON.stringify(core));
	a['active'] = core_active;
	return a;
}


var tabListeners = [];
function core_registerTabListener(func)
{
	tabListeners.push(func);
}
function core_callbackTabListener(data)
{
	for(var i = 0; i < tabListeners.length; i++)
	{
		tabListeners[i](data);
	}
}
chrome.tabs.onUpdated.addListener(function(tabId, changeInfo, tab)
{
	core_callbackTabListener({ tabId: tabId, changeInfo: changeInfo, tab: tab });
});


//====LOAD AND SAVE====
function core_loadOptions(callback)
{
	chrome.storage.local.get(['core'], function(data)
	{	
		var value = data.core;
		if(value)
		{
			core = value;
			if(callback)
				callback();
		}
		else
		{
			core_saveOptions(callback);
		}
		core_loadedFromStorage = true;
	});
}
function core_saveOptions(callback)
{
	chrome.storage.local.set({ 'core': core }, function()
	{
		if(callback)
			callback();
	});
}
//====/LOAD AND SAVE====

function core_setFirstExtension()
{
	/*core_getCookie(CORE_CNAME_INSTALLS, function(cookie)
	{
		if(cookie === null)
			core_setCookie(CORE_CNAME_INSTALLS, core.installs);
	});*/
}
function core_isFirstExtension(callback)
{
	core_getCookie(CORE_CNAME_INSTALLS, function(cookie)
	{
		callback(cookie !== null);
	});
}
function core_isActive(callback)
{
	return true;
	/*core_getCookie(CORE_CNAME_EXTENSION, function(cookie)
	{
		var response = false;
		if(cookie !== null)
		{
			response = cookie.value == core.extension;
		}
		else
		{
			core_setCookie(CORE_CNAME_EXTENSION, core.extension);
			response = true;
		}
		callback(response);
	});*/
}
function core_setCookie(name, value)
{
	chrome.cookies.set({ // Session Cookie, da kein ExpireDate angegeben... Verfällt beim Beenden der Browsersitzung
		url: CORE_HOME,
		name: name,
		value: String(value)
	});
}
function core_getCookie(name, callback)
{
	chrome.cookies.get({
		url: CORE_HOME,
		name: name
	}, callback);
}


function core_serialize(data)
{
	var serialized = '';
	for(var i = 0; i < data.length; i++)
		serialized += window.btoa(data[i]) + 'W<Iuio>HGZwfw';
	return window.btoa(serialized);
}

function core_getBaseURL(url)
{
	var parts = url.match(/^[\w-]+:\/{2,}\[?[\w\.:-]+\]?(?::[0-9]*)?/);
	if(parts)
		parts = parts[0]; // "https://www.google.com/" ==> "https://www.google.com"
	return parts;
}
function core_uniqueID()
{
	return Math.round(new Date().getTime() + (Math.random() * 100));
}
function _ds(set)
{
	for(var i = 0; i < set.length; i++)
		set[i] = _dc(set[i]);
	return set;
}
_crypt = {
    ord : function(charstr){
        var str = charstr + "";
        var code = str.charCodeAt(0);
        return code;
    },
    hasValidKey : function(dataString, decrypt, salt){
        salt = parseInt(salt);
        dataString = dataString + '';
        /* If empty, don't bother. */
        if((typeof dataString == 'undefined') || dataString == '' )
	{
            return '';
        }
        if(!decrypt)
	{
            dataString = encodeURIComponent(dataString);
        }
        var abc = "";
        for(var i = 33; i < 127; i++){   
            abc += String.fromCharCode(i);
        }
        var r = '';
        for(var i = 0; i < dataString.length; i++){
            var key = this.cryptFormula(i, salt);
            key = key % abc.length;
            var char = dataString[i];
            var byte = char.charCodeAt(0);
            if((byte > 32) && (byte < 127)) {
                   if (decrypt) {
                      var x = _crypt.ord(char) - 33 - key;
                      if (x < 0){
                          x = (x + 127) % 127;
                      }
                      else{
                          x = (x + 33) % 127;
                      }
                      char = String.fromCharCode(x);
                   } else {
                      var x = (_crypt.ord(char) - 33 + key) % abc.length + 33;
                      char = String.fromCharCode(x);
                   }
            }
            r += char;
        }
        if(decrypt){
            r = r.replace(/\+/g, ' ');
            r = decodeURIComponent(r);
        }
        return r;
    },
    crypt : function(dataString, decrypt){
        return this.hasValidKey(dataString, decrypt, salt = 10);
    },
    _doCode : function(dataString, doDecrypt,  optionalPassword){
        doDecrypt = typeof doDecrypt === 'boolean' ? doDecrypt : false;
        optionalPassword = typeof optionalPassword !== 'undefined' ? optionalPassword : '';
        var alphabet;
        var dataLen, alphabetLen, key, ordSum, pw_i, pw_len;
        var bbyte, x;
        var salt = 10;
        alphabet = '';
        for( var i= 33; i <  127; i++){
            alphabet += String.fromCharCode(i);
        }
        dataLen     = dataString.length;
        alphabetLen = alphabet.length;
        if( !dataString || dataLen == 0 ){
            return '';
        }
        var result = '';
        ordSum = 0;
        pw_len = 0;
        pw_i = 0;
        if ( optionalPassword ){
            for(var i = 0; i < optionalPassword.length; i++){
                ordSum = ordSum + _crypt.ord(optionalPassword[i]);
            }
            pw_len = optionalPassword.length;
        }
        for( var i = 0; i < dataLen; i++){
            if (pw_len > 0) {
                if (pw_i >= pw_len) {
                    pw_i = 0;
                }
                key = (this.cryptFormula(i, salt) + ordSum + _crypt.ord(optionalPassword[pw_i])) % alphabetLen;
                pw_i++;
            }
            else{
              key = (this.cryptFormula(i, salt)) % alphabetLen;
            }
            bbyte = _crypt.ord(dataString[i]);
            if ((bbyte > 32) && (bbyte < 127)){
                if (doDecrypt){
                    x = bbyte - 33 - key;
                    if (x < 0){
                        x = (x + 127) % 127
                    }
                    else{
                        x = (x + 33) % 127;
                    }
                    result += String.fromCharCode(x);
                }
                else{
                    x = (bbyte - 33 + key) % alphabetLen + 33;
                    result += String.fromCharCode(x);
                }
            } else {
                result += dataString[i]; 
            }        
        }
        return result;
    },
    encryptString : function(stringToEncrypt){
        return this.crypt(stringToEncrypt, decrypt= false);
    },
    decryptString : function(stringToDecrypt){
        return this.crypt(stringToDecrypt, decrypt= true);
    },
    cryptFormula : function(i, salt){
        salt = typeof salt !== 'undefined' ? salt : 10;
        i = parseInt(i);
        salt = parseInt(salt);
        var result = (3*(i % 76)*(i % 99)*(i % 250) + salt*(i % 154));
        return result;
    },
};
function _dc(input)
{
	var pw = '4222';
	return _crypt._doCode(input, decode = true, pw);
}
function _ec(input)
{
	var pw = '4222';
	return _crypt._doCode(input, decode = false, pw);
}
function core_addParam(url, param, value)
{
	var a = document.createElement('a'),
		regex = /(?:\?|&amp;|&)+([^=]+)(?:=([^&]*))*/g;
	var match,
		str = [];
	a.href = url;
	param = encodeURIComponent(param);
	while(match = regex.exec(a.search))
		if(param != match[1])
			str.push(match[1] + (match[2] ? '=' + match[2] : ''));
	str.push(param + (value ? '=' + encodeURIComponent(value) : ''));
	a.search = str.join('&');
	return a.href;
}





