'use strict';

{

    let details = {};

    (() => {
        const matches = /details=([^&]+)/.exec(window.location.search);
        if (matches === null) {
            return;
        }
        try {
            details = JSON.parse(decodeURIComponent(matches[1]));
        } catch (ex) {}
    })();


    uDom('.what').text(details.url);

    (() => {
        const reURL = /^https?:\/\//;

        const liFromParam = function(name, value) {
            if (value === '') {
                value = name;
                name = '';
            }
            const li = document.createElement('li');
            let span = document.createElement('span');
            span.textContent = name;
            li.appendChild(span);
            if (name !== '' && value !== '') {
                li.appendChild(document.createTextNode(' = '));
            }
            span = document.createElement('span');
            if (reURL.test(value)) {
                const a = document.createElement('a');
                a.href = a.textContent = value;
                span.appendChild(a);
            } else {
                span.textContent = value;
            }
            li.appendChild(span);
            return li;
        };

        const safeDecodeURIComponent = function(s) {
            try {
                s = decodeURIComponent(s);
            } catch (ex) {}
            return s;
        };

        const renderParams = function(parentNode, rawURL) {
            const a = document.createElement('a');
            a.href = rawURL;
            if (a.search.length === 0) {
                return false;
            }

            const pos = rawURL.indexOf('?');
            const li = liFromParam(
                vAPI.i18n('mainBlockedNoParamsPrompt'),
                rawURL.slice(0, pos)
            );
            parentNode.appendChild(li);

            const params = a.search.slice(1).split('&');
            for (let i = 0; i < params.length; i++) {
                const param = params[i];
                let pos = param.indexOf('=');
                if (pos === -1) {
                    pos = param.length;
                }
                const name = safeDecodeURIComponent(param.slice(0, pos));
                const value = safeDecodeURIComponent(param.slice(pos + 1));
                const li = liFromParam(name, value);
                if (reURL.test(value)) {
                    const ul = document.createElement('ul');
                    renderParams(ul, value);
                    li.appendChild(ul);
                }
                parentNode.appendChild(li);
            }
            return true;
        };

        const hasParams = renderParams(uDom.nodeFromId('parsed'), details.url);
        if (hasParams === false) {
            return;
        }

        const theURLNode = document.getElementById('theURL');
        theURLNode.classList.add('hasParams');
        theURLNode.classList.toggle(
            'collapsed',
            vAPI.localStorage.getItem('document-blocked-collapse-url') === 'true'
        );

        const toggleCollapse = function() {
            vAPI.localStorage.setItem(
                'document-blocked-collapse-url',
                theURLNode.classList.toggle('collapsed').toString()
            );
        };

        theURLNode.querySelector('.collapse').addEventListener(
            'click',
            toggleCollapse
        );
        theURLNode.querySelector('.expand').addEventListener(
            'click',
            toggleCollapse
        );
    })();


    if (window.history.length > 1) {
        uDom('#back').on('click', function() {
            window.history.back();
        });
        uDom('#bye').css('display', 'none');
    } else {
        uDom('#bye').on('click', function() {
            window.close();
        });
        uDom('#back').css('display', 'none');
    }


    vAPI.messaging.send('main-blocked.js', {
        what: 'mustBlock',
        scope: details.hn,
        hostname: details.hn,
        type: details.type,
    }).then(response => {
        if (response === false) {
            window.location.replace(details.url);
        }
    });

}