'use strict';

(function() {

    let details = {};

    (function() {
        let matches = /details=([^&]+)/.exec(window.location.search);
        if (matches === null) {
            return;
        }
        try {
            details = JSON.parse(decodeURIComponent(matches[1]));
        } catch (ex) {}
    })();

    uDom('.what').text(details.url);

    (function() {
        if (typeof URL !== 'function') {
            return;
        }

        const reURL = /^https?:\/\//;

        const liFromParam = function(name, value) {
            if (value === '') {
                value = name;
                name = '';
            }

            let li = document.createElement('li');
            let span = document.createElement('span');
            span.textContent = name;
            li.appendChild(span);
            if (name !== '' && value !== '') {
                li.appendChild(document.createTextNode(' = '));
            }
            span = document.createElement('span');
            if (reURL.test(value)) {
                let a = document.createElement('a');
                a.href = a.textContent = value;
                span.appendChild(a);
            } else {
                span.textContent = value;
            }
            li.appendChild(span);
            return li;
        };

        const safeDecodeURIComponent = function(s) {
            try {
                s = decodeURIComponent(s);
            } catch (ex) {}
            return s;
        };

        const renderParams = function(parentNode, rawURL, step) {
            if (0 === step) {
                return true;
            }

            let a = document.createElement('a');
            a.href = rawURL;
            if (a.search.length === 0) {
                return false;
            }

            let pos = rawURL.indexOf('?');
            let li = liFromParam(
                vAPI.i18n('mainBlockedNoParamsPrompt'),
                rawURL.slice(0, pos)
            );
            parentNode.appendChild(li);

            let params = a.search.slice(1).split('&');
            for (let i = 0; i < params.length; ++i) {
                let param = params[i];
                pos = param.indexOf('=');
                if (pos === -1) {
                    pos = param.length;
                }
                let name = safeDecodeURIComponent(param.slice(0, pos));
                let value = safeDecodeURIComponent(param.slice(pos + 1));
                li = liFromParam(name, value);

                if (reURL.test(value)) {
                    let ul = document.createElement('ul');
                    renderParams(ul, value, step - 1);
                    li.appendChild(ul);
                }
                parentNode.appendChild(li);
            }

            return true;
        };

        if (renderParams(uDom.nodeFromId('parsed'), details.url, 3) === false) {
            return;
        }

        const hasParams = renderParams(uDom.nodeFromId('parsed'), details.url);
        if (hasParams === false) {
            return;
        }

        const theURLNode = document.getElementById('theURL');
        theURLNode.classList.add('hasParams');
        theURLNode.classList.toggle(
            'collapsed',
            vAPI.localStorage.getItem('document-blocked-collapse-url') === 'true'
        );

        const toggleCollapse = function() {
            vAPI.localStorage.setItem(
                'document-blocked-collapse-url',
                theURLNode.classList.toggle('collapsed').toString()
            );
        };

        theURLNode.querySelector('.collapse').addEventListener(
            'click',
            toggleCollapse
        );
        theURLNode.querySelector('.expand').addEventListener(
            'click',
            toggleCollapse
        );
    })();


    if (window.history.length > 1) {
        uDom('#back').on('click', function() {
            window.history.back();
        });
        uDom('#bye').css('display', 'none');
    } else {
        uDom('#bye').on('click', function() {
            window.close();
        });
        uDom('#back').css('display', 'none');
    }


    vAPI.messaging.send('main-blocked.js', {
        what: 'mustBlock',
        scope: details.hn,
        hostname: details.hn,
        type: details.type,
    }).then(response => {
        if (response === false) {
            window.location.replace(details.url);
        }
    });

})();