﻿/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Profile Manager and Selector (pmOptions.js).
 *
 * The Initial Developer of the Original Code is Weidong Lu.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Weidong Lu <lwd.firefox@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//Define global variables
var syncAddCount = 0;
var syncDelCount = 0;
var syncDelDirCount = 0;
var syncUpCount = 0;
var syncDownCount = 0;
var gProfileINIPath;
var pmOptions = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("profilemanager.");

var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                                .getService(Components.interfaces.nsIXULAppInfo)
                                .QueryInterface(Components.interfaces.nsIXULRuntime);                                    
if (appInfo.OS == "Linux"){      
        gProfileINIPath = Components.classes["@mozilla.org/file/directory_service;1"]
                         .getService(Components.interfaces.nsIProperties)
                         .get("DefProfRt", Components.interfaces.nsIFile);
    }
    else {
        gProfileINIPath = Components.classes["@mozilla.org/file/directory_service;1"]
                         .getService(Components.interfaces.nsIProperties)
                         .get("DefProfRt", Components.interfaces.nsIFile).parent;
    } 
gProfileINIPath.append("profiles.ini");

var profileService = Components.classes["@mozilla.org/toolkit/profile-service;1"]
                     .getService(Components.interfaces.nsIToolkitProfileService); 

var profilePath = Components.classes["@mozilla.org/file/directory_service;1"]
                  .getService(Components.interfaces.nsIProperties)
                  .get("DefProfRt", Components.interfaces.nsIFile);
                  
var profDir =  Components.classes["@mozilla.org/file/directory_service;1"]
                  .getService(Components.interfaces.nsIProperties)
                  .get("ProfD", Components.interfaces.nsIFile);      
                  
                  
var gSyncFlag = "";

var gProfileINIArray = pm_parseProfileINI();

if (appInfo.OS != "Darwin"){
    var alertS = Components.classes["@mozilla.org/alerts-service;1"]
                               .getService(Components.interfaces.nsIAlertsService);
}
                           
function pm_initOptions(){
    
    try{
    document.documentElement.centerWindowOnScreen();
        
    document.getElementById("showToolbarButton").checked = pmOptions.getIntPref("opt_showToolbarButton");
    document.getElementById("showStatusbarButton").checked = pmOptions.getIntPref("opt_showStatusbarButton");
    document.getElementById("showProfileName").checked = pmOptions.getIntPref("opt_showProfileName");
    document.getElementById("showOpenLink").checked = pmOptions.getIntPref("opt_showOpenLink");
    document.getElementById("showOpenPage").checked = pmOptions.getIntPref("opt_showOpenPage");
    document.getElementById("pm_noDefaultProfile").checked = pmOptions.getIntPref("opt_noDefaultProfile");
    document.getElementById("pm_setDefaultProfile").disabled = pmOptions.getIntPref("opt_noDefaultProfile");
    document.getElementById("pm_automaticalSync").checked = pmOptions.getIntPref("opt_syncAutomatic");
    document.getElementById("pm_autoSyncInterval").value = pmOptions.getIntPref("opt_syncAutoInterval");
    document.getElementById("pm_syncOnStartup").checked = pmOptions.getIntPref("opt_syncOnStartup")   
    document.getElementById("pm_syncOnShutdown").checked = pmOptions.getIntPref("opt_syncOnShutdown");
    document.getElementById("pm_syncCountNotification").checked = pmOptions.getIntPref("opt_syncCountNotification");
    document.getElementById("pm_uuidDisplay").value = "GUID of this Profile: " + pm_readUUID(profDir.path);

    pm_listBoxInit(document.getElementById("pm_duplicateExceptionList"), pmOptions.getCharPref("opt_duplicateExceptionList"));
    pm_listBoxInit(document.getElementById("pm_syncExceptionList"), pmOptions.getCharPref("opt_syncExceptionList"));
    
    var defaultProfileName = pmOptions.getCharPref("opt_defaultProfileName");
    var syncFromProfileName = pmOptions.getCharPref("opt_syncFromProfileName");
    var syncToProfileName = pmOptions.getCharPref("opt_syncToProfileName");
    var profileListbox = document.getElementById("pm_profileList");
    var profileSyncFrom = document.getElementById("pm_syncFrom");
    var profileSyncTo = document.getElementById("pm_syncTo");
    
    for (i = 0; i < gProfileINIArray[0].length; i++){
        var listitem = profileListbox.appendItem(gProfileINIArray[0][i], gProfileINIArray[0][i]); 
        listitem.setAttribute("tooltiptext", "Profile name: " + gProfileINIArray[0][i] +"\nProfile path:  "+ gProfileINIArray[1][i]);
        profileSyncTo.appendItem(gProfileINIArray[0][i], gProfileINIArray[0][i]);
        profileSyncFrom.appendItem(gProfileINIArray[0][i], gProfileINIArray[0][i]);
        
        if (syncFromProfileName == gProfileINIArray[0][i]) profileSyncFrom.selectedIndex = i;
        if (syncToProfileName == gProfileINIArray[0][i]) profileSyncTo.selectedIndex = i;
    } 
    
    profileListbox.selectedIndex = 0;
    profileListbox.focus();
    
    if (pmOptions.getIntPref("opt_noDefaultProfile") == 0) {
        var defaultIndex = gProfileINIArray[0].indexOf(defaultProfileName);
        if (defaultIndex != -1){
            profileListbox.getItemAtIndex(defaultIndex).setAttribute("label", defaultProfileName+" (default)");
            profileListbox.selectedIndex = defaultIndex;        
            pmOptions.setIntPref("opt_defaultProfileIndex", defaultIndex);
        } else alert("Es wurde kein Standard Profil eingestellt oder der Name des Standard Profils wurde geändert. \n\nBitte stellen Sie ein Standard Profil durch klicken auf die Als Standard Profil einstellen Schaltfläche im Einstellungen Fenster!")
    }
    }catch(e){alert(e);}
}

function pm_parseProfileINI(){ // all absolute path
    
    profileINI = pm_readProfileINI();
    
    var profileINIArray = new Array(3); 
    profileINIArray[0] = profileINI.match(/Name=.*/g);
    profileINIArray[1] = profileINI.match(/Path=.*/g);
    profileINIArray[2] = profileINI.match(/IsRelative=.*/g);

    for (i = 0; i < profileINIArray[0].length;i++) {
        profileINIArray[0][i] = profileINIArray[0][i].replace("Name=", "");
        profileINIArray[1][i] = profileINIArray[1][i].replace("Path=", "");
        profileINIArray[2][i] = profileINIArray[2][i].replace("IsRelative=", "");
        if (profileINIArray[2][i].indexOf("1") != -1){ // if it is relative path, convert it to full path
            if (profilePath.path.indexOf("\\") != -1) {  // in windows env else in linux env
                profileINIArray[1][i] = profilePath.path + profileINIArray[1][i].replace(/^(Profiles)/g, "");
                profileINIArray[1][i] = profileINIArray[1][i].replace(/[/]/g, "\\");
            } else profileINIArray[1][i] = profilePath.path + "/" +profileINIArray[1][i].replace(/^Profiles\//g, "");
        }
    }
    return profileINIArray;
}

function pm_readProfileINI(){
    
    var profileINI = "";
    
    if (gProfileINIPath.exists()){
        
        var fstream = Components.classes["@mozilla.org/network/file-input-stream;1"]
        .createInstance(Components.interfaces.nsIFileInputStream);
        var sstream = Components.classes["@mozilla.org/scriptableinputstream;1"]
        .createInstance(Components.interfaces.nsIScriptableInputStream);
        
        fstream.init(gProfileINIPath, -1, 0, 0);
        sstream.init(fstream); 
        
        var str = sstream.read(4096);
        while (str.length > 0) {
            profileINI += str;
            str = sstream.read(4096);
        }
        
        sstream.close();
        fstream.close();
        
        return profileINI;
        
    } else {
        
        alert("Es wurde keine profiles.ini Datei gefunden.\nEntweder Ihre profiles.ini Datei ist zusammengebrochen oder Sie verwenden eine Portable Version von Firefox.\n\nDie profile.ini Datei wird neu Erstellt und Firefox wird neu gestartet um die Änderungen abzuschliessen.");
                        
        profileINI = "[General]\r\nStartWithLastProfile=1\r\n\r\n";
        profileINI = profileINI + "[Profile0]\r\n";
        profileINI = profileINI + "Name=default\r\n";
        profileINI = profileINI + "IsRelative=0\r\n";
        profileINI = profileINI + "Path="+profDir.path+"\r\n";
        profileINI = profileINI + "Default=1\r\n";
        pm_writeProfileINI(profileINI, "overwrite");
        restartApp(false);
    }
}

function pm_writeProfileINI(textToWrite, flag){
    
    var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
    .createInstance(Components.interfaces.nsIFileOutputStream);
    
    if (flag == "append") foStream.init(gProfileINIPath, 0x02 | 0x10, 0666, 0); // append
    else if (flag == "overwrite") foStream.init(gProfileINIPath, 0x02 | 0x08 | 0x20, 0666, 0); // write, create, truncate
    
    foStream.write(textToWrite, textToWrite.length);
    foStream.close();
}

function pm_listBoxInit( listBox, listString ){
    
    if (listString != "") {
        var stringArray = listString.split("||");		
        for (var n = 0; n < stringArray.length; n++) {
            listBox.appendItem(stringArray[n], stringArray[n]);
        }
    }
}

function pm_goToProfile(){
    
    var selectedProfileIndex = document.getElementById("pm_profileList").selectedIndex;
    if (selectedProfileIndex == -1) alert("Bitte zuerst ein Profil aus der Liste auf der linken Seite auswählen.");
    else {
        var profileName = document.getElementById("pm_profileList").selectedItem.value;        
        var selectedProfilePath = gProfileINIArray[1][gProfileINIArray[0].indexOf(profileName)];
        var profilePath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
        profilePath.initWithPath(selectedProfilePath);
        if (profilePath.exists()) profilePath.launch();
        else alert("Der Profil Ordner existiert nicht! \n\nSie können auf die Schaltfläche Profile Name - Ordner bearbeiten klicken um den korrekten Pfad für dieses Profil wieder herzustellen.");
    }
}

function pm_openProfileINI(){
    
    if (confirm("Vorsicht bei allen Änderungen in der profiles.ini. Sie könnten in Ihrem ganzes Profil System in ein totales Chaos verursachen!!!")) {
        try{
        var profileINI = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
        
        profileINI.initWithPath(gProfileINIPath.path);
        profileINI.launch();
        }catch(e){alert(e);}
    }
}

function pm_setNoDefaultProfile(){

    if (document.getElementById("pm_noDefaultProfile").checked == 1) document.getElementById("pm_setDefaultProfile").disabled = true;
    else {
        document.getElementById("pm_setDefaultProfile").disabled = false;
		alert("Bitte ein Standard Profil einstellen, klicken Sie dazu auf die Schaltfläche Als Standard Profil einstellen!");
    }
}

function pm_setDefaultProfile(){
    
    var defaultProfileIndex = pmOptions.getIntPref("opt_defaultProfileIndex");
    var defaultProfileName = pmOptions.getCharPref("opt_defaultProfileName");
    
    var profileList = document.getElementById("pm_profileList");
    
    var pm_selectedProfileIndex = profileList.selectedIndex; 
    
    var pm_selectedProfile = document.getElementById("pm_profileList").selectedItem;
    
    if (pm_selectedProfileIndex == -1) alert("Bitte ein Profil in der Liste auf der Linken Seite auswählen!");
    else {        
        if (defaultProfileIndex != -1){
            profileList.getItemAtIndex(defaultProfileIndex).setAttribute("label", defaultProfileName); // remove *** use index to find the right profile
        }
        pm_selectedProfile.setAttribute("label", pm_selectedProfile.value+"(default)"); // add as default 
        
        pmOptions.setCharPref("opt_defaultProfileName", pm_selectedProfile.value); // save settings. 
        pmOptions.setIntPref("opt_defaultProfileIndex", pm_selectedProfileIndex);
    }
}

function pm_syncAutomaticChecked(){
    
    if (pmOptions.getIntPref("opt_syncAutomatic") == 0){
        pmOptions.setIntPref("opt_syncAutomatic", 1);
        if ((pmOptions.getCharPref("opt_syncFromProfileName") != "" ) && (pmOptions.getCharPref("opt_syncToProfileName"))){
            alert("Ein Neustart von Firefox ist notwendig. \n\nFirefox wird automatisch beim nächsten Neustart die ausgewählten Profile synchronisieren.")
        }else alert("Bitte wählen Sie unter dem Punkt Profile synchronisieren die Profile zum synchronisieren aus und starten Sie Firefox neu. \n\nFirefox wird automatisch beim nächsten Neustart die ausgewählten Profile synchronisieren.")
    }
}

function pm_saveOptions(){
    
    var toolbarOriginal = pmOptions.getIntPref("opt_showToolbarButton");
    var statusbarOriginal = pmOptions.getIntPref("opt_showStatusbarButton");
    var showProfileNameOriginal = pmOptions.getIntPref("opt_showProfileName");
    var showOpenLink = pmOptions.getIntPref("opt_showOpenLink");
    var showOpenPage = pmOptions.getIntPref("opt_showOpenPage");
    
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
    var win = wm.getMostRecentWindow("navigator:browser"); // get the main browser window
    
    pmOptions.setIntPref("opt_syncAutomatic", document.getElementById("pm_automaticalSync").checked);
    
    if ((document.getElementById("pm_syncFrom").selectedIndex != -1) && (document.getElementById("pm_syncTo").selectedIndex != -1)){
        pmOptions.setCharPref("opt_syncFromProfileName", document.getElementById("pm_syncFrom").selectedItem.value);
        pmOptions.setCharPref("opt_syncToProfileName", document.getElementById("pm_syncTo").selectedItem.value);
    }
    pmOptions.setIntPref("opt_syncOnStartup", document.getElementById("pm_syncOnStartup").checked);
    pmOptions.setIntPref("opt_syncOnShutdown", document.getElementById("pm_syncOnShutdown").checked);
    pmOptions.setIntPref("opt_syncCountNotification", document.getElementById("pm_syncCountNotification").checked);

    var syncInterval = document.getElementById("pm_autoSyncInterval").value;
    
    if (syncInterval.search(/^[0-9]+$/g) != -1){ // determine whether the input is a real number or not 
        pmOptions.setIntPref("opt_syncAutoInterval", parseInt(syncInterval));
    } else {
        pmOptions.setIntPref("opt_syncAutoInterval", 0);
        alert("Falsche Zahl! Es sind nur ganze Zahlen - Nummern im automatsich synchronisieren Zeit Feld erlaubt. \n\nDer im Feld angegebene Wert wurde auf 0 zurück gesetzt.");
    } 
    
    if (statusbarOriginal != document.getElementById("showStatusbarButton").checked){
        
        pmOptions.setIntPref("opt_showStatusbarButton", document.getElementById("showStatusbarButton").checked);        
        if (win) {
            if (document.getElementById("showStatusbarButton").checked == 1) {
                win.document.getElementById("pm-status-panel").setAttribute("hidden", false);
            } else win.document.getElementById("pm-status-panel").setAttribute("hidden", true);
        }
    }     
    
    if (toolbarOriginal != document.getElementById("showToolbarButton").checked){
        pmOptions.setIntPref("opt_showToolbarButton", document.getElementById("showToolbarButton").checked);        
        if (win) {
            if (document.getElementById("showToolbarButton").checked == 1) {
                win.document.getElementById("pm_button").setAttribute("hidden", false);
            } else win.document.getElementById("pm_button").setAttribute("hidden", true);
        }
    }
    
    if (showProfileNameOriginal != document.getElementById("showProfileName").checked){
        pmOptions.setIntPref("opt_showProfileName", document.getElementById("showProfileName").checked);        
        if (win) {
            if (document.getElementById("showProfileName").checked == 1) {
                win.document.getElementById("pm_profileName").setAttribute("hidden", false);
            } else win.document.getElementById("pm_profileName").setAttribute("hidden", true);            
        }
    }
    
    if (showOpenLink != document.getElementById("showOpenLink").checked){
        pmOptions.setIntPref("opt_showOpenLink", document.getElementById("showOpenLink").checked);        
        if (win) {
            if (document.getElementById("showOpenLink").checked == 1) {
                win.document.getElementById("pm_showOpenLink").setAttribute("hidden", false);
                win.document.getElementById("pm_showBookmarkOpenLink").setAttribute("hidden", false);
            } else {
                win.document.getElementById("pm_showOpenLink").setAttribute("hidden", true);            
                win.document.getElementById("pm_showBookmarkOpenLink").setAttribute("hidden", true);            
            }
        }
    }
    
    if (showOpenPage != document.getElementById("showOpenPage").checked){
        pmOptions.setIntPref("opt_showOpenPage", document.getElementById("showOpenPage").checked);        
        if (win) {
            if (document.getElementById("showOpenPage").checked == 1) {
                win.document.getElementById("pm_showOpenPage").setAttribute("hidden", false);
            } else win.document.getElementById("pm_showOpenPage").setAttribute("hidden", true);            
        }
    }
    
    pmOptions.setIntPref("opt_noDefaultProfile", document.getElementById("pm_noDefaultProfile").checked);    
    
    if (document.getElementById("pm_noDefaultProfile").checked == 1) {
        pmOptions.setCharPref("opt_defaultProfileName", "");
        pmOptions.setIntPref("opt_defaultProfileIndex", -1);    
    } else if (pmOptions.getIntPref("opt_defaultProfileIndex") == -1){
         alert("Sie haben den Haken bei 'Kein Standard Profil einstellen entfernt'. \n\n Bitte ein Standard Profil einstellen durch klicken auf die 'Als Standard Profil einstellen' Schaltfläche.");
         win.openDialog("chrome://profilemanager/content/pmOptions.xul","showOptions", "chrome, resizable=yes");
     }
     
}

function pm_manageListbox(listbox, listitemName, flag){
    
    var pmWin = window.arguments[3];
    var selIndex = listbox.selectedIndex;

    switch (flag){
        case "add":
        listbox.appendItem(listitemName, listitemName);
        pmWin.document.getElementById("pm_syncTo").appendItem(listitemName, listitemName);
        pmWin.document.getElementById("pm_syncFrom").appendItem(listitemName, listitemName);
        break;
        
        case "del":
        listbox.removeItemAt(selIndex);
        pmWin.document.getElementById("pm_syncTo").removeItemAt(selIndex);
        pmWin.document.getElementById("pm_syncFrom").removeItemAt(selIndex);
        break;
        
        case "rename":
        var listItem = listbox.getItemAtIndex(listbox.selectedIndex);
        listItem.setAttribute("label", listitemName);
        listItem.setAttribute("value", listitemName);
        pmWin.document.getElementById("pm_syncTo").removeItemAt(selIndex);
        pmWin.document.getElementById("pm_syncFrom").removeItemAt(selIndex);
        pmWin.document.getElementById("pm_syncTo").insertItemAt(selIndex, listitemName, listitemName);
        pmWin.document.getElementById("pm_syncFrom").insertItemAt(selIndex, listitemName, listitemName);
        break;
    }
}

function pm_addFileToList(idName){
    
    var listbox; 
    var fileName;
    var dupExceptionList = pmOptions.getCharPref("opt_duplicateExceptionList");
    
    if (idName == "pm_duplicateFileAdd"){
        fileName = document.getElementById("pm_duplicateFileNameToAdd").value;
        fileName = fileName.replace(/^[ \t\r\n]+|[ \t\r\n]+$/g, "");
        listbox = document.getElementById("pm_duplicateExceptionList");
        if (!pm_fileInList(dupExceptionList,fileName)){
            if (dupExceptionList.search(/\w/g) != -1){
                dupExceptionList = dupExceptionList + "||" + fileName;
            } else dupExceptionList = fileName;
            listbox.appendItem(fileName, fileName);
        } else alert("Datei Name ist bereits vorhanden!");
        
        pmOptions.setCharPref("opt_duplicateExceptionList", dupExceptionList);
        
    }else if (idName == "pm_syncFileAdd"){
        
        fileName = document.getElementById("pm_syncFileNameToAdd").value;
        fileName = fileName.replace(/^[ \t\r\n]+|[ \t\r\n]+$/g, "");
        listbox = document.getElementById("pm_syncExceptionList");
        var syncExceptionList = pmOptions.getCharPref("opt_syncExceptionList");
        if (!pm_fileInList(dupExceptionList, fileName)){
            if (!pm_fileInList(syncExceptionList, fileName)){
                if (syncExceptionList.search(/\w/g) != -1){
                    syncExceptionList = syncExceptionList + "||" + fileName;
                }
                else {
                    syncExceptionList = fileName;          
                }
                listbox.appendItem(fileName, fileName);
            } else alert("Datei Name ist in dieser Liste bereits vorhanden.");
        } else alert("Datei Name ist in der Kopieren Ausnahmen Liste bereits vorhanden. \n\n Keine in der Kopieren Ausnahmen Liste vorhandenen Dateien wird synchronisiert.");
        
        pmOptions.setCharPref("opt_syncExceptionList", syncExceptionList);
    }    
}

function pm_fileInList(list, fName){

    var aArray = list.split("||");
    if (aArray.indexOf(fName) == -1) return false;
    else return true;
}

function pm_removeFileFromList(idName){
    
    var listbox;
    var fileName;
    var fileList = ["pmSync.log", "uuidSync.log", "parent.lock", "lock", ".parentlock", "places.sqlite-journal", "Cache"];
    
    if (idName == "pm_duplicateFileRemove"){
        listbox = document.getElementById("pm_duplicateExceptionList");
        fileName = listbox.selectedItem.value;
        if (fileList.indexOf(fileName) !=  -1) {
            alert("Diese Datei kann nicht entfernt werden!");
            return false;
        }

        listbox.removeItemAt(listbox.selectedIndex);
        var dupExceptionList = pmOptions.getCharPref("opt_duplicateExceptionList");
        if (dupExceptionList.indexOf(fileName+"||") != 0){ // file is not the first item
            if (dupExceptionList.indexOf("||") != -1) {
                dupExceptionList = dupExceptionList.replace("||"+fileName, "");
            } else dupExceptionList = dupExceptionList.replace(fileName, "");
        } else {
            dupExceptionList = dupExceptionList.replace(fileName+"||", "");
        }
        
        pmOptions.setCharPref("opt_duplicateExceptionList", dupExceptionList);
        
    }else if (idName == "pm_syncFileRemove"){
        
        listbox = document.getElementById("pm_syncExceptionList");
        fileName = listbox.selectedItem.value;
        if (fileList.indexOf(fileName) !=  -1) {
            alert("Diese Datei kann nicht entfernt werden!");
            return false;
        }
        listbox.removeItemAt(listbox.selectedIndex);
        var syncExceptionList = pmOptions.getCharPref("opt_syncExceptionList");
        if (syncExceptionList.indexOf(fileName+"||") != 0){ // file is not the first item
            if (syncExceptionList.indexOf("||") != -1) {
                syncExceptionList = syncExceptionList.replace("||"+fileName, "");
            } else syncExceptionList = syncExceptionList.replace(fileName, "");
        } else {
            syncExceptionList = syncExceptionList.replace(fileName+"||", "");
        }
        pmOptions.setCharPref("opt_syncExceptionList", syncExceptionList);
    }
    return true;
}
function pm_openLogFile(){
    
    var remoteProfileName = pmOptions.getCharPref("opt_syncToProfileName");
    var dstSyncLog = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    try{
        dstSyncLog.initWithPath(gProfileINIArray[1][gProfileINIArray[0].indexOf(remoteProfileName)]);
        dstSyncLog.append("pmSync.log");
        dstSyncLog.launch();
    }catch(e){
        alert("Fehler: Die 'pmSync.log' Datei existiert nicht oder das entfernte Profil existiert nicht.")
    }
}

function pm_writeToLog(file, profileName, syncAction, pmUUID){

    var data = "";
    
    var fstream = Components.classes["@mozilla.org/network/file-input-stream;1"]
    .createInstance(Components.interfaces.nsIFileInputStream);
    var sstream = Components.classes["@mozilla.org/scriptableinputstream;1"]
    .createInstance(Components.interfaces.nsIScriptableInputStream);
    fstream.init(file, -1, 0, 0);
    sstream.init(fstream); 
    
    var loopLimit = 0;
    var str = sstream.read(4096);
    while ((str.length > 0) && (loopLimit < 3)) {
        data += str;
        str = sstream.read(4096);
        loopLimit++;
    }
    
    sstream.close();
    fstream.close();
    
    data = pmUUID + "::" + syncAction + "::" + profileName + "\r\n" + data;
    
    var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
    .createInstance(Components.interfaces.nsIFileOutputStream);
        
    foStream.init(file, 0x02 | 0x08 | 0x20, 0666, 0); // write, create, truncate
    
    foStream.write(data, data.length);
    foStream.close();
}

function pm_readUUID(srcProfilePath){
    
    var pmUUID = "";
    var uuidFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    
    uuidFile.initWithPath(srcProfilePath);
    uuidFile.append("extensions");
    uuidFile.append("uuidSync.log");
    
    if (uuidFile.exists()) { // read uuid
        var uuidStream = Components.classes["@mozilla.org/network/file-input-stream;1"]
                         .createInstance(Components.interfaces.nsIFileInputStream);
           
        uuidStream.init(uuidFile, 0x01, 0444, 0); 
        uuidStream.QueryInterface(Components.interfaces.nsILineInputStream);
               
        var line = {};
        uuidStream.readLine(line);
        uuidStream.close();
        pmUUID = line.value;
    } else { // create a new uuidSync.log and return uuid
        var uuidGenerator = Components.classes["@mozilla.org/uuid-generator;1"]
                            .getService(Components.interfaces.nsIUUIDGenerator);
        var uuid = uuidGenerator.generateUUID();
        pmUUID = uuid.toString();
        
        try{
            uuidFile.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0600);
        }catch(e){alert(e);}
        
        var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
        .createInstance(Components.interfaces.nsIFileOutputStream);
        
        foStream.init(uuidFile, 0x02 | 0x08 | 0x20, 0600, 0); // write, create, truncate
        
        var data = pmUUID + "\r\n\r\n\r\n" +"Das ist eine automatisch generierte Datei von der Erweiterung 'Profile manager and synchronizer' und wird dazu verwendet, um eine eindeutige universelle Kennung (UUID), zu speichern. Diese Kennung wir generiert, um  dieses Profil während der Synchronisation eindeutig zu identifizieren. Bitte diese Datei nicht löschen.";
        foStream.write(data, data.length);
        foStream.close();
    }    
    return pmUUID;
}

// synchronize profile
function pm_synchronizeProfile(syncflag){
    var localProfileName; 
    var remoteProfileName;

    try{
        if (window.title != "Profile Manager and Synchronizer Options") {
            localProfileName = pmOptions.getCharPref("opt_syncFromProfileName");
            remoteProfileName = pmOptions.getCharPref("opt_syncToProfileName");
        } else {
            try { 
                localProfileName = document.getElementById("pm_syncFrom").selectedItem.value;
                remoteProfileName = document.getElementById("pm_syncTo").selectedItem.value;
            } catch (e){
                alert("Die zu synchronisierenden Profile sind nicht korrekt eingestellt worden. Bitte wählen Sie die zu synchronisierenden Profil erneut aus.");
            }
            if ((localProfileName != null) && (remoteProfileName != null)) {
                pmOptions.setCharPref("opt_syncFromProfileName", localProfileName);
                pmOptions.setCharPref("opt_syncToProfileName", remoteProfileName);
            } else alert("Die zu synchronisierenden Profile sind nicht korrekt eingestellt worden. Bitte wählen Sie die zu synchronisierenden Profil erneut aus.");
        }
        
        var localProfilePath = gProfileINIArray[1][gProfileINIArray[0].indexOf(localProfileName)];
        var remoteProfilePath = gProfileINIArray[1][gProfileINIArray[0].indexOf(remoteProfileName)];
           
           if ((localProfilePath == null) || (remoteProfilePath == null)){
               alert("Synchronisations Fehler: weder Profil"+ localProfileName +" noch " + remoteProfileName + " konnten gefunden werden! \n\nBitte wählen Sie nochmals die zu synchronisierenden Profile in den Einstellungen unter Punkt Profil Synchronisation");
               return false;
           }
           
           if ((localProfilePath == null) || (remoteProfilePath == null)){
               alert("Die von Ihnen zur Synchronisation ausgewählten Profile sind identisch. Bitte wählen Sie zwei unterschiedliche Profile.");
               return false;
           }
           
           // save prefs.js for updates 
           var pmPrefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
           var pmPrefJS = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);           
           pmPrefJS.initWithPath(profDir.path);
           pmPrefJS.append("prefs.js");
           pmPrefService.savePrefFile(pmPrefJS);
           
           dstSyncLog = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
           dstSyncLog.initWithPath(remoteProfilePath);
           dstSyncLog.append("pmSync.log");    
           
           var pmUUID = pm_readUUID(localProfilePath);

           var syncStream = Components.classes["@mozilla.org/network/file-input-stream;1"]
           .createInstance(Components.interfaces.nsIFileInputStream);
           
           switch (syncflag){
               case "sync":
               
               if (!dstSyncLog.exists()){
                   try{
                       dstSyncLog.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0666);
                   }catch(e){alert(e);}
               } 
               
               syncStream.init(dstSyncLog, 0x01, 0444, 0); 
               syncStream.QueryInterface(Components.interfaces.nsILineInputStream);
               
               var line = {};
               syncStream.readLine(line);
               syncStream.close();
               var record;
               
               if (line.value.indexOf("::") != -1) record = line.value.split("::");
               else record = ["", ""];
               
               var operationFlag = "upload";
               var syncStatChanged = false;
               var buttonSync = -1;
        
               if ((record[0].indexOf(pmUUID) == -1) && (record[1].indexOf("upload") != -1)){ 
                   // other place uploaded a new profile, then confirm to download.
                   operationFlag = "download";
                   if (pmOptions.getIntPref("opt_syncAutomatic") == 1){ // disable automatic sync and wait for the confirmation
                       pmOptions.setIntPref("opt_syncAutomatic", 0);
                       syncStatChanged = true;
                   }
                   
                   var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
				          .getService(Components.interfaces.nsIPromptService);
                   var check = {value: false};                  // default the checkbox to false
                   var flags = prompts.BUTTON_POS_0 * prompts.BUTTON_TITLE_IS_STRING +
                   prompts.BUTTON_POS_1 * prompts.BUTTON_TITLE_IS_STRING +
                   prompts.BUTTON_POS_2 * prompts.BUTTON_TITLE_IS_STRING;
                   buttonSync = prompts.confirmEx(null, "Profil Synchronisations Konflikt", "Firefox hat festgestellt, dass Ihr Profil von einem anderen Ort aktualisiert wurde. Möchten Sie die aktualisierete Datei zuerst runter laden? \n\n Die download Aktion benötigt einen Firefox Neustart um die Änderungen abzuschließen. Sie können auch auswählen nichts zu tun oder mit dem hochladen fort zufahren.", flags, "Herunter laden","nichts tun", "Hoch laden", null, check);
               }
               
               if (buttonSync == 0){ // download button is pressed
                   // download
                   if (syncStatChanged) pmOptions.setIntPref("opt_syncAutomatic", 1);
                   pmOptions.setCharPref("opt_lastSyncOperation", "download");
                   pmOptions.setCharPref("opt_lProfilePath", localProfilePath);
                   pmOptions.setCharPref("opt_rProfilePath", remoteProfilePath);
                   pm_writeToLog(dstSyncLog, localProfileName, "download", pmUUID);
                   
                   //pm_syncDir(remoteProfilePath, localProfilePath, "COPY_EXTRA", 1);
                   //pm_syncDir(localProfilePath, remoteProfilePath, "DEL_EXTRA", 1);       
                   //pm_writeToLog(dstSyncLog, localProfileName, "download", pmUUID);
                   
                   restartApp(true);
               
               } else if (buttonSync == 2){ // upload button is pressed
                   // continue to upload
                   if (syncStatChanged) pmOptions.setIntPref("opt_syncAutomatic", 1);
                   pmOptions.setCharPref("opt_lastSyncOperation", "upload");
            
                   pm_syncDir(localProfilePath, remoteProfilePath, "COPY_EXTRA", 1);
                   pm_syncDir(remoteProfilePath, localProfilePath, "DEL_EXTRA", 1);
                   pm_writeToLog(dstSyncLog, localProfileName, "upload", pmUUID);
               } else if (buttonSync == 1){ // do nothing button is pressed
                   if (syncStatChanged) pmOptions.setIntPref("opt_syncAutomatic", 1);
               } else if (buttonSync == -1){ // there is no update of the profile from the other place and continue to upload
                   // continue to upload
                   if (syncStatChanged) pmOptions.setIntPref("opt_syncAutomatic", 1);
                   pmOptions.setCharPref("opt_lastSyncOperation", "upload");
                   
                   pm_syncDir(localProfilePath, remoteProfilePath, "COPY_EXTRA", 1);
                   pm_syncDir(remoteProfilePath, localProfilePath, "DEL_EXTRA", 1);
                   pm_writeToLog(dstSyncLog, localProfileName, "upload", pmUUID);
               }	
               break;
               
               case "download": //
               if (confirm ("Durch das runter laden wird das lokale Profil gelöscht und durch das entfernte Profil ersetzt. \n\nÜberschreibe lokales Profil '"+localProfileName+"' mit emfernten Profil '"+remoteProfileName+"'? ")){
                   var delFlag = false;
                   try{
                       localProfile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                       localProfile.initWithPath(localProfilePath);
                       if (pm_checkProfileFolder(localProfile)) {
                           localProfile.remove(true);
                           delFlag = true;
                       }
                       else if (confirm ("Dieser Ordner: "+localProfilePath+" sieht nicht wie ein Profil Ordner aus. Soll dieser Ordner wirklich entfernt werden?")){ 
                           localProfile.remove(true);
                           delFlag = true;
                       }
                   }catch(e){
                       //alert(e);
                   }
                   if (delFlag && pm_copyDir(remoteProfilePath, localProfilePath, 1)) {
                       if (appInfo.OS != "Darwin"){
                           alertS.showAlertNotification("", "Profil erfolgreich runtergeladen", "Profil erfolgreich runtergeladen", 
                                                           false, "", null);
                       }
                   }
                   else alert("Während des kopierens ist ein Fehler aufgetreten. Download wurde unterbrochen.");
               }
               break;
                        
               case "upload":
               if (confirm ("Durch das hochladen wird das entfernte Profil gelöscht und durch das lokale Profil ersetzt. \n\nÜberschreibe entferntes Profil'"+remoteProfileName+"' mit lokalen Profil '"+localProfileName+"'? ")){
                   var delFlag = false;
                   try{
                       remoteProfile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                       remoteProfile.initWithPath(remoteProfilePath);
                       
                       if (pm_checkProfileFolder(remoteProfile)) {
                           remoteProfile.remove(true);
                           delFlag = true;
                       }
                       else if (confirm ("Dieser Ordner: "+remoteProfilePath+" sieht nicht wie ein Profil Ordner aus. Wollen Sie ihn wirklich entfernen?")){ 
                           remoteProfile.remove(true);
                           delFlag = true;
                       }
                   }catch(e){
                       //alert(e);
                   }
                   if (delFlag && pm_copyDir(localProfilePath, remoteProfilePath, 1)) {
                       if (appInfo.OS != "Darwin"){

                           alertS.showAlertNotification("", "Profil erfolgreich hoch geladen", "Profil erfolgreich hoch geladen",
                                                    false, "", null);
                       
                       }
                   }
                   else alert("Während des kopierens ist ein Fehler aufgetreten. Das Hochladen wurde unterbrochen.");
               }
               break;
           }//end switch
    
           if (pmOptions.getIntPref("opt_syncCountNotification") == 1) {
               if ((syncflag != "download") && (syncflag != "upload") && (buttonSync != 1 )){
                   var updateCount = syncDownCount + syncUpCount;
                   var alertText = "";
                   if (updateCount > 0) alertText = alertText + updateCount + " files updated; ";
                   if (syncAddCount > 0) alertText = alertText + syncAddCount + " files added; ";
                   if (syncDelCount > 0) alertText = alertText + syncDelCount + " files deleted; ";
                   if (syncDelDirCount > 0) alertText = alertText + syncDelDirCount + " Dirs deleted; ";
                   
                   if ((updateCount ==0)&&(syncAddCount==0)&&(syncDelCount == 0)&&(syncDelDirCount==0)) alertText = alertText + "Es werden zur Zeit keine Dateien synchronisiert.";
                   if (appInfo.OS != "Darwin"){

                       alertS.showAlertNotification("chrome://profilemanager/skin/syncLarge.png", "Erfolgreich synchronisiert", alertText, false, "", null);            
                   }
                   syncDownCount = 0;
                   syncUpCount = 0;
                   syncDelCount = 0;
                   syncAddCount = 0;
                   syncDelDirCount = 0;
               } // end if flag
           }// end if pmOptions
       }catch(e){alert(e);}

}// end function


// check directory 
function pm_checkProfileFolder(profileFolder){
    
    if (!profileFolder.exists()) return false;
    
    var entries = profileFolder.directoryEntries;
    var isProfile = false;
    var numOfFiles = 0; 
    
    while(entries.hasMoreElements()){
        var entry = entries.getNext().QueryInterface(Components.interfaces.nsIFile);
       
        if ((entry.leafName == "pref.js") || (entry.leafName == "localstore.rdf")||(entry.leafName == "chrome")) {
            numOfFiles++;
        }    
        if (numOfFiles > 2){
            isProfile = true;
            break; 
        }
    }
    return isProfile;
}

// copy files and

function pm_copyDir(srcDir, dstDir, noAlert){
    
    var duplicateExceptionList = pmOptions.getCharPref("opt_duplicateExceptionList");
    var syncExceptionList = pmOptions.getCharPref("opt_syncExceptionList");
    
    var sourceDir = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    if (!sourceDir) return false;
    
    try{
        sourceDir.initWithPath(srcDir);
    }catch(e){ alert("Fehler: Das Quellen Verzeichnis'"+srcDir+"' existiert nicht.");}
    
    var entries = sourceDir.directoryEntries;
    
    while(entries.hasMoreElements()){
        var entry = entries.getNext().QueryInterface(Components.interfaces.nsIFile);
        var src = entry.path;
        if (entry.isDirectory()) {
            var relativePath = src.replace(srcDir, "");
            if (!pm_fileInList(duplicateExceptionList, relativePath)){
                var dst = dstDir + relativePath;
                pm_copyDir(src,dst,noAlert);
            }
        }else{
            var file = entry.leafName;
            if (!pm_fileInList(duplicateExceptionList, file)){
                pm_CopyFile(srcDir,dstDir,file, noAlert);
            }
        }
    }
    return true;
}

function pm_syncDir(srcDir, dstDir, flag, noAlert){
    
    var duplicateExceptionList = pmOptions.getCharPref("opt_duplicateExceptionList");
    var syncExceptionList = pmOptions.getCharPref("opt_syncExceptionList");
    
    var sourceDir = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    if (!sourceDir) return false;
    sourceDir.initWithPath(srcDir);
    var srcEntries = sourceDir.directoryEntries;
    
    var destDir = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    if (!destDir) return false;
    destDir.initWithPath(dstDir);
    
    while (srcEntries.hasMoreElements() ){
        var entry = srcEntries.getNext().QueryInterface(Components.interfaces.nsIFile);
        var src = entry.path;
        if (entry.isDirectory()) {
            var relativePath = src.replace(srcDir, "");
            if (!pm_fileInList(duplicateExceptionList, relativePath)){
                var dst = dstDir + relativePath;
                var dstTempDir = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                if (!dstTempDir) return false;
                dstTempDir.initWithPath(dst);
                
                if (dstTempDir.exists()) pm_syncDir(src, dst, flag, noAlert);
                else {
                    if (flag == "COPY_EXTRA") pm_syncDir(src, dst, flag, noAlert);
                    else if (flag == "DEL_EXTRA") {entry.remove(true); syncDelDirCount++;}
                }
            }
        } // end if 
        else {
            var file = entry.leafName;
            if ((!pm_fileInList(duplicateExceptionList, file)) && (!pm_fileInList(syncExceptionList, file))) {
                pm_SyncFile(srcDir,dstDir,file,flag,noAlert);
            }// end if
        }// end else
    } //end while
}

function pm_SyncFile(srcDir, dstDir, fName, flag, noAlert){
    
    var srcFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    if (!srcFile) return false;
    srcFile.initWithPath(srcDir);
    srcFile.append(fName);
    
    var destDir = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    if (!destDir) return false;
    destDir.initWithPath(dstDir);
    
    var sourceDir = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    if (!sourceDir) return false;
    sourceDir.initWithPath(srcDir);
    
    var tmpFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    tmpFile.initWithPath(dstDir);
    tmpFile.append(fName);
    
    if (tmpFile.exists()) { // tmp file exists 
        if (flag != "DEL_EXTRA"){ // compare srcFile with tmpFile(destFile)
            if ((tmpFile.lastModifiedTime != srcFile.lastModifiedTime)||(tmpFile.fileSize != srcFile.fileSize)) { 
                try{
                   // if (fName == "prefs.js") {alert(srcFile.path);alert(tmpFile.path);}
                    //try{
                    tmpFile.remove(false);
                    srcFile.copyTo(destDir,fName);
                    //}catch(e){alert(tmpFile.path+"\n"+srcFile.path+"\n"+e);}
                    //alert(destDir.path+fName);
                    syncUpCount++;
                }catch(e){
                    
                    if (noAlert == 0) alert("Profil kopieren wegen Fehler beendet. Beim kopieren der Datei '"+fName+"'. \n\n ist ein Fehler aufgetreten. \n\n Bitte diesen Datei Namen in die Kopieren Ausnahmen Liste unter Einstellungen, Kopieren Ausnahmen, einfügen.");
                    return false;
                }
            } else { // download
                // if (tmpFile.lastModifiedTime > srcFile.lastModifiedTime){
                //     try{
                //         srcFile.remove(false);
                //         tmpFile.copyTo(sourceDir,fName);
                //         syncDownCount++;
                //     }catch(e){
                //         if (noAlert == 0) alert("Profile duplication terminated with error. There is an error while copying file '"+fName+"'. \n\n Please put this file name in the Duplicate Excepction List in the Options Dialog.");
                //         return false;
                //     }
                // }// end if tmpFile.last..
            }// end else download ..
        } // end if flag != DEL...
    } else { // the file does not exist in dstDir tmpFile.exists() == false
        try{
        if (flag == "COPY_EXTRA"){
            srcFile.copyTo(destDir,fName);
            syncAddCount++;
        } else if (flag == "DEL_EXTRA"){
            srcFile.remove(false);
            syncDelCount++;
        }
    }catch(e){
        alert(srcFile.path + flag + e);
    }
    }
    return true;
}


function pm_CopyFile(srcDir,dstDir,fName, noAlert){
    
    var srcFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    if (!srcFile) return false;

    var destDir = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    if (!destDir) return false;
    
    srcFile.initWithPath(srcDir);
    srcFile.append(fName);
    destDir.initWithPath(dstDir);
 
    var tmpFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    tmpFile.initWithPath(dstDir);
    tmpFile.append(fName);
    try{
        tmpFile.remove(false);
    }catch(e){
        //alert(e);
    }
		
    try{
        srcFile.copyTo(destDir,fName);
    }catch(e){
        if (noAlert == 0) alert("Profil kopieren mit einem Fehler beendet. Beim kopieren der Datei '"+fName+"'ist ein Fehler aufgetreten. \n\n Bitte diesen Datei Namen in die Kopieren Ausnahmen Liste unter Einstellungen, Kopieren Ausnahmen, einfügen.");
        return false;
    }
    return true;
}

function pm_editProfile(flag){
    
    var selectedProfileIndex = document.getElementById("pm_profileList").selectedIndex;
    if (selectedProfileIndex == -1) alert("Bitte zuerst ein Profil aus der Liste auf der linken Seite auswählen.");
    else {
        var srcProfileName = document.getElementById("pm_profileList").selectedItem.value;        
        window.openDialog('chrome://profilemanager/content/pmEditProfile.xul','showEditDialog', 'chrome,titlebar,resizable=yes', srcProfileName, flag, gProfileINIArray, window);
    }
}

function pm_initEditProfileDialog(){
    try{
    var srcProfileName = window.arguments[0];
    var profileINIArray = window.arguments[2];
    var flag = window.arguments[1];
    var srcProfilePath = profileINIArray[1][profileINIArray[0].indexOf(srcProfileName)];
    
    document.getElementById("pm_newProfileName").hidden = false;
    document.getElementById("pm_editDialogPath").hidden = false;
    document.getElementById("pm_newProfilePath").hidden = false;
    document.getElementById("pm_locateProfilePath").hidden = false;
    document.getElementById("pm_editDescription").value = "";
    
    switch (flag){
        case "create":
        window.title="Neues Profil erstellen:";
        document.getElementById("pm_editDialogName").value = "Name des neuen Profils: ";
        document.getElementById("pm_editDialogPath").value = "Quellen Pfad des neuen Profils: ";
        document.getElementById("pm_newProfilePath").setAttribute("value", profilePath.path);
        var pathTextbox = document.getElementById("pm_editProfileVbox"); 
        var newCheckbox = pathTextbox.appendChild(document.createElement("checkbox"));
        newCheckbox.setAttribute("id","pm_copyThisExtension");
        newCheckbox.setAttribute("label", "Das Add-on (profile manager and synchronizer) in das neue Profil installieren.");
        break;
        
        case "edit":
        window.title="Profil Name und Pfad bearbeiten:";
        document.getElementById("pm_editDialogName").value = "Profil Name ändern zu: ";
        document.getElementById("pm_editDialogPath").value = "Profil Pfad ändern nach: ";
        document.getElementById("pm_newProfileName").value = srcProfileName;
        document.getElementById("pm_newProfilePath").setAttribute("value", srcProfilePath);
        var pathTextbox = document.getElementById("pm_editProfileVbox"); 
        var newCheckbox = pathTextbox.appendChild(document.createElement("checkbox"));
        newCheckbox.setAttribute("id","pm_editProfileCheckbox");
        newCheckbox.setAttribute("label", "Auch den Original Profil Ordner zu dem neuen Pfad verschieben." );
        document.getElementById("pm_editDescription").value = "Anmerkung: Das Verschieben des Profilordners kann etwas länger dauern, bitte warten!";

        break;
        
        case "delete":
        window.title="Profil löschen:";
        document.getElementById("pm_editDialogName").value = "Profil löschen bestätigen '"+srcProfileName+"'?";
        var editDialog = document.getElementById("pm_EditProfileDialog");
        var newCheckbox = editDialog.appendChild(document.createElement("checkbox"));
        newCheckbox.setAttribute("id","pm_removeProfileFolder");
        newCheckbox.setAttribute("label", "Auch alle Dateien im Profil Ordner löschen: "+srcProfilePath);
        document.getElementById("pm_newProfilePath").hidden = true;
        document.getElementById("pm_newProfileName").hidden = true;
        document.getElementById("pm_editDialogPath").hidden = true;
        document.getElementById("pm_locateProfilePath").hidden = true;
        break;
        
        case "duplicate":
        window.title="Profil kopieren::";
        document.getElementById("pm_editDialogName").value = "Neuer Profil Name: ";
        document.getElementById("pm_editDialogPath").value = "Neuer Profil Pfad: ";
        document.getElementById("pm_newProfilePath").setAttribute("value", profilePath.path);
        document.getElementById("pm_editDescription").value = "Anmerkung: Das Kopieren der Profilordner kann etwas länger dauern, bitte warten!";

        break;
        
        case "backup":
        window.title="Sicherheits Kopie des Profil Ordners erstellen:";
        document.getElementById("pm_editDialogName").value = "Sichern des Profil Ordners, nach: ";
        document.getElementById("pm_newProfilePath").setAttribute("value", "");
        document.getElementById("pm_newProfileName").hidden = true;
        document.getElementById("pm_editDialogPath").hidden = true;
        document.getElementById("pm_editDescription").value = "Anmerkung: Das Sichern der Profilordner kann etwas länger dauern, bitte warten!";

        break;
        
        case "backupINI":
        window.title="Profiles.ini Datei sichern :";
        document.getElementById("pm_editDialogName").value = "Profiles.ini Datei sichern, nach: ";
        document.getElementById("pm_newProfilePath").setAttribute("value", "");
        document.getElementById("pm_newProfileName").hidden = true;
        document.getElementById("pm_editDialogPath").hidden = true;
        break;
        
        case "backupAll":
        window.title="Alle Profile und die profiles.ini Datei sichern :";
        document.getElementById("pm_editDialogName").value = "Alle Profile und die profiles.ini Datei sichern nach: ";
        document.getElementById("pm_newProfilePath").setAttribute("value", "");
        document.getElementById("pm_newProfileName").hidden = true;
        document.getElementById("pm_editDialogPath").hidden = true;
        document.getElementById("pm_editDescription").value = "Anmerkung: Das Kopieren der Profilordner kann etwas länger dauern, bitte warten!";

        break;
        
        case "restoreINI":
        window.title=  "Profiles.ini wieder herstellen:";
        document.getElementById("pm_editDialogName").value = "Quelle der gesicherten profiles.ini Datei ";
        document.getElementById("pm_newProfilePath").setAttribute("value", "");
        document.getElementById("pm_newProfileName").hidden = true;
        document.getElementById("pm_editDialogPath").hidden = true;
        break;
        
        case "restoreProfile":
        window.title="Profil Ordner wieder herstellen:";
        document.getElementById("pm_editDialogName").value = "Die gesicherten Profil Ordner, Quelle: ";
        document.getElementById("pm_newProfilePath").setAttribute("value", "");
        document.getElementById("pm_newProfileName").hidden = true;
        document.getElementById("pm_editDialogPath").hidden = true;
        document.getElementById("pm_editDescription").value = "Anmerkung: Das Kopieren der Profilordner kann etwas länger dauern, bitte warten!";

        break;
        
        case "restoreAll":
        window.title=  "Alles wieder herstellen:";
        document.getElementById("pm_editDialogName").value = "Die gesicherten Profile und die profiles.ini Datei, Quelle:";
        document.getElementById("pm_newProfilePath").setAttribute("value", "");
        document.getElementById("pm_newProfileName").hidden = true;
        document.getElementById("pm_editDialogPath").hidden = true;
        document.getElementById("pm_editDescription").value = "Anmerkung: Das Kopieren der Profilordner kann etwas länger dauern, bitte warten!";

        break;
    }
	}catch(e){alert(e);}
}

function pm_locateProfilePath(){
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    
    fp.init(window, null, nsIFilePicker.modeGetFolder); 
    fp.displayDirectory = profilePath;
    
    var result = fp.show();
    if (result == nsIFilePicker.returnOK) {
        document.getElementById("pm_newProfilePath").setAttribute("value", fp.file.path);
    }
}

function pm_saveEditProfileDialog(){
	try{
    var newProfileName = document.getElementById("pm_newProfileName").value;
    var newProfileDir = document.getElementById("pm_newProfilePath").value;


    var newProfilePath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    if (newProfileDir != "") {
        try{
            newProfilePath.initWithPath(newProfileDir);
        }catch(e){ alert(e); }
        //newProfilePath.append(newProfileName);
    }

    var srcProfileName = window.arguments[0];
    var flag = window.arguments[1];
	var profileINIArray = window.arguments[2];
    var srcProfilePath = profileINIArray[1][profileINIArray[0].indexOf(srcProfileName)];
    
    
    if (flag == "edit"){
        var moveFileFlag = document.getElementById("pm_editProfileCheckbox").checked;
        
        if (newProfilePath.path != srcProfilePath){
            if (moveFileFlag == 1) flag = "editBothMove";
            else flag = "editBoth";
        }  else if (newProfileName != srcProfileName){
            if  (profileINIArray[0].indexOf(newProfileName) == -1) flag = "editName";
			else {
				alert("Der Profil Name existiert schon! Bitte einen anderen Namen wählen!");
				flag = "NoChange";
				return false;
			}
        } else flag = "NoChange";
    } else if ((flag == "create") || (flag == "duplicate")) { // other actions than edit
        
        if (profileINIArray[0].indexOf(newProfileName) != -1){
            alert("Der Profil Name existiert schon! Bitte einen anderen Namen wählen!");
            flag = "NoChange";
			return false;
        } 
	} 
    
    pm_makeChangesProfile(srcProfileName, newProfileName, newProfilePath, flag);
	}catch(e){alert(e);}
}


function pm_makeChangesProfile(srcProfileName, newProfileName, newProfilePath, flag){
            
    var confirmText;
    var optionWin = window.arguments[3];
    var gProfileINIArray = window.arguments[2];
    var srcProfileIndex = gProfileINIArray[0].indexOf(srcProfileName);
    
    switch (flag){
        case "NoChange": 
        break;
        
        case "create":
        newProfilePath.append(newProfileName);                
        confirmText = "Ein neues Profil erstellen: "+ newProfileName+"\und den Pfad:"+newProfilePath.path+"\n\nBestätigen?";
        if (confirm(confirmText)){
            var newProfile = profileService.createProfile(newProfilePath, null, newProfileName);            
            gProfileINIArray[0].push(newProfileName);
            gProfileINIArray[1].push(newProfilePath.path);

            pm_manageListbox(optionWin.document.getElementById("pm_profileList"), newProfileName, "add");
        }
        if (document.getElementById("pm_copyThisExtension").checked == 1){
            var extensionPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            extensionPath.initWithPath(gProfileINIArray[1][srcProfileIndex]);
            extensionPath.append("extensions");
            extensionPath.append("{69f6e5ea-e975-4d70-a983-1e5c094ded79}");
            var destPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            destPath.initWithPath(newProfile.rootDir.path);
            destPath.append("extensions");
            if (!destPath.exists()) destPath.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0744);
            extensionPath.copyTo(destPath,"{69f6e5ea-e975-4d70-a983-1e5c094ded79}");
        }
        if (appInfo.OS != "Darwin"){

            alertS.showAlertNotification("", "Profil erfolgreich erstellt", "Das Profil wurde erfolgreich erstellt!", false, "", null);
        }
        break;
        
        case "editName":
        confirmText = "Profil Name ändern zu: "+ newProfileName+"\n\nBestätigen?";
        if (confirm(confirmText)){
            if (pmOptions.getCharPref("opt_defaultProfileName") == srcProfileName) pmOptions.setCharPref("opt_defaultProfileName", newProfileName);
            if (pmOptions.getCharPref("opt_syncFromProfileName") == srcProfileName) pmOptions.setCharPref("opt_syncFromProfileName", newProfileName);
            if (pmOptions.getCharPref("opt_syncToProfileName") == srcProfileName) pmOptions.setCharPref("opt_syncToProfileName", newProfileName);
            gProfileINIArray[0][srcProfileIndex] = newProfileName;
            pm_manageListbox(optionWin.document.getElementById("pm_profileList"), newProfileName, "rename");
        }
        break;
        
        case "editBoth": //  write both name and path to profiles.ini 

        confirmText = "Profil Name ändern zu: "+ newProfileName+"\nProfil Pfad ändern zu: "+ newProfilePath.path +"\n\n**Achtung**: Um die Änderungen abzuschließen mus Firefox neu gestartet werden. \n\nBestätigen?";
        if (confirm(confirmText)){
            if (pmOptions.getCharPref("opt_defaultProfileName") == srcProfileName) pmOptions.setCharPref("opt_defaultProfileName", newProfileName);
            if (pmOptions.getCharPref("opt_syncFromProfileName") == srcProfileName) pmOptions.setCharPref("opt_syncFromProfileName", newProfileName);
            if (pmOptions.getCharPref("opt_syncToProfileName") == srcProfileName) pmOptions.setCharPref("opt_syncToProfileName", newProfileName);
            
            gProfileINIArray[0][srcProfileIndex] = newProfileName;
            gProfileINIArray[1][srcProfileIndex] = newProfilePath.path;
            
            pm_manageListbox(optionWin.document.getElementById("pm_profileList"), newProfileName, "rename");
        }
        else { 
            alert("Fehler: Der korrekte Profil Pfads wurde nicht gefunden: "+srcProfileName+"\nProfil Pfad wurde nicht verändert.");
            return false;
        }
        
        break;
        
        case "editBothMove": // profile folder move 

        newProfilePath.append(newProfileName);                
        confirmText = "Profil Name ändern zu: "+ newProfileName+"\nProfil Pfad ändern zu: "+ newProfilePath.path +"\nund den Profil Ordner verschieben von: "+gProfileINIArray[1][srcProfileIndex]+"\n                           nach: "+ newProfilePath.path +"\n\nBestätigen?";
        if (confirm(confirmText)){
            try{
                if (pmOptions.getCharPref("opt_defaultProfileName") == srcProfileName) pmOptions.setCharPref("opt_defaultProfileName", newProfileName);
                if (pmOptions.getCharPref("opt_syncFromProfileName") == srcProfileName) pmOptions.setCharPref("opt_syncFromProfileName", newProfileName);
                if (pmOptions.getCharPref("opt_syncToProfileName") == srcProfileName) pmOptions.setCharPref("opt_syncToProfileName", newProfileName);
            
            } catch(e){
                alert(e);
            }
            
            // move folder
            if (pm_copyDir(gProfileINIArray[1][srcProfileIndex], newProfilePath.path, 0)){ 
                // first copy original profile folder
                // when successful, remove original profile folder
            if (appInfo.OS != "Darwin"){
                alertS.showAlertNotification("", "Erfolgreich", "Das gewälte Profil ist erfolgreich verschoben worden! Neuer Speicher Ort: "+newProfilePath.path, false, "", null);
            }
                try{
                    srcProfile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                    srcProfile.initWithPath(gProfileINIArray[1][srcProfileIndex]);
                    srcProfile.remove(true);
                } catch (e) {
                    alert(e);
                }
            }
            
            gProfileINIArray[0][srcProfileIndex] = newProfileName;
            gProfileINIArray[1][srcProfileIndex] = newProfilePath.path;
        }        
        break;
        
        case "delete":
        var deleteFileFlag = document.getElementById("pm_removeProfileFolder").checked;

		srcProfile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
		srcProfile.initWithPath(gProfileINIArray[1][srcProfileIndex]);

        if (deleteFileFlag == 1){
            var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
				          .getService(Components.interfaces.nsIPromptService);
            var check = {value: false};                  // default the checkbox to false

            var flags = prompts.BUTTON_POS_0 * prompts.BUTTON_TITLE_OK +
            prompts.BUTTON_POS_1 * prompts.BUTTON_TITLE_CANCEL  +
            prompts.BUTTON_POS_2 * prompts.BUTTON_TITLE_IS_STRING;

            var button = prompts.confirmEx(null, "Bestätigen Sie das löschen des Profil Ordners", "Bestätigen Sie das löschen des Profil Ordners:"+srcProfile.path+" ?",flags, "", "", "Gehen Sie zu diesem Ordner", null, check);
            if (button == 2) {
                srcProfile.launch();
                return false;
            } else {
                if (button == 0) {
                    try{
                        if (srcProfile.path == profilePath) { 
                            alert("Der Profil Hauptordner ist ein System Ordner und kann nicht gelöscht werden!")
                            deleteFileFlag = 0;
                        }
                         srcProfile.remove(deleteFileFlag);
                    } catch (e){
                        alert(e);
                    }
                }// end button == 0
                pm_manageListbox(optionWin.document.getElementById("pm_profileList"), newProfileName, "del");
                
                try{
                    gProfileINIArray[0].splice(srcProfileIndex, 1);				
                    gProfileINIArray[1].splice(srcProfileIndex, 1);
                } catch(e){
                    alert(e);
                    return false;
                }
                if (appInfo.OS != "Darwin"){

                    alertS.showAlertNotification("", "Profil erfolgreich gelöscht", "Das ausgewählte Profil wurde erfolgreich gelöscht.", false, "", null);
                }
            }
        }// end if deleteFileFlag == 1
        		
        break;
        
        case "duplicate": // both write to profiles.ini and folder copy


			confirmText = "Profil kopieren: von '" + srcProfileName + "' nach '"+ newProfileName + "'. \n\nBestätigen?";
			if (confirm(confirmText)){            
				newProfilePath.append(newProfileName);
				if (gProfileINIArray[1][srcProfileIndex] != newProfilePath.path){
					// copy profile folder
					if (pm_copyDir(gProfileINIArray[1][srcProfileIndex], newProfilePath.path, 0)) {//copy 
                                            if (appInfo.OS != "Darwin"){
                                                alertS.showAlertNotification("", "Profil erfolgreich kopiert", "Das Profil wurde erfolgreich kopiert!", false, "", null);
                                            }
                                        }        
                                        pm_manageListbox(optionWin.document.getElementById("pm_profileList"), newProfileName, "add");
					gProfileINIArray[0].push(newProfileName);
					gProfileINIArray[1].push(newProfilePath.path);
				} else {
					alert("Fehler: Der Pfad zum kopierten Profil ist identisch mit dem Pfad zu original Profil. Bitte anderen Pfad auswählen.");
					return false;
				}
			}
			break;
        
        case "backup": // no write to profiles.ini only folder copy
        newProfilePath.append(srcProfileName);                
        confirmText = "Profil Ordner '" + srcProfileName + "' sichern nach: \n\n"+ newProfilePath.path + "\n\nBestätigen?"            
        if (confirm(confirmText)){ //copy folder only
            if (pm_copyDir(gProfileINIArray[1][srcProfileIndex], newProfilePath.path, 0)){ //copy 
                if (appInfo.OS != "Darwin"){
                    alertS.showAlertNotification("", "Profile erfolgreich gesichert", "Alle Profile wurden erfolgreich kopiert - bzw. gesichert!", false, "", null);
                }
            }
        }
        break;
        
        case "backupINI":
        confirmText = "Profiles.ini Datei Sichern nach: \n\n"+ newProfilePath.path + "\n\nBestätigen?"            
        if (confirm(confirmText)){ //copy folder only
            if (gProfileINIPath.exists()){
                gProfileINIPath.copyTo(newProfilePath, "profiles.ini");
            } else alert("Profile.ini konnte nicht gefunden werden");
        }        
        break;
        
        case "backupAll":
        confirmText = "Alle Profile und die Profiles.ini Datei Sichern nach: \n\n"+ newProfilePath.path + "\n\nDies Aktion kann etwas länger dauern.\n\nBestätigen?"            
        
        if (confirm(confirmText)){ //copy folder only
            if (gProfileINIPath.exists()){
                gProfileINIPath.copyTo(newProfilePath, "profiles.ini");
            }
            try{
                for (i = 0; i < gProfileINIArray[0].length; i++){
                    var targetPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                    targetPath.initWithPath(newProfilePath.path);
                    targetPath.append(gProfileINIArray[0][i]);
                    pm_copyDir(gProfileINIArray[1][i], targetPath.path, 0); //copy 
                }
            }catch(e){
                //alert(gProfileINIArray[1][i]);
                alert("Während der Sicherung Ihrer Profile ist ein unbekannter Fehler auf geteten: \n'"+gProfileINIArray[0][i]+"' \n("+gProfileINIArray[1][i]+").\n\nSicherung wurde beendet.")
                return false;
            }
            if (appInfo.OS != "Darwin"){
                alertS.showAlertNotification("", "Profile erfolgreich gesichert", "Es wurde erfolgreich eine Sicherung Ihrer Profile hergestellt.", false, "", null);
            }
        }
        break;
        
        case "restoreINI":
        confirmText = "Profiles.ini wieder herstellen, von: \n\n"+ newProfilePath.path + "\die Profiles.ini Datei wird überschrieben und kann nicht wieder hergestellt werden. Bitte ziehen Sie in Betracht zuerst eine Sicherung - Kopie der aktuellen profiles.ini  Datei zu erstellen. \n\nDiese Operation verlangt einen Neustart von Firefox.\n\nBestätigen?"
        if (confirm(confirmText)){ //copy folder only
            
            var iniPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            iniPath.initWithPath(gProfileINIPath.path);
                        
            var srcPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            srcPath.initWithPath(newProfilePath.path);
            srcPath.append("profiles.ini");
            
            if (srcPath.exists()){
                if (iniPath.exists()){
                    iniPath.remove(false);
                }
                srcPath.copyTo(gProfileINIPath.parent, "profiles.ini");
            restartApp(true);
            } else alert("In diesem Ordner ist keine profiles.ini Datei vorhanden. Bitte wählen Sie den korrekten Pfad zum richtigen Speicherort der profiles.ini Datei.");
        }
        break;
    
        case "restoreProfile":
        var profileIndex = gProfileINIArray[0].indexOf(newProfilePath.leafName);
        if (profileIndex == -1) {
            alert("Fehler: Es wurde kein Profil benannt '"+ newProfilePath.leafName+"'. Bitte ändern Sie den Quellen Ordner Namen zu einem in diesem Profil System existierenden Profil.");
            return false;
        }

        confirmText = "Profile wieder herstellen '"+newProfilePath.leafName+"' von: \n\n"+ newProfilePath.path + "\nDer aktuelle Profil Ordner wird überschrieben und kann nicht wieder hergestellt werden. Bitte ziehen Sie in Betracht zuerst eine Sicherung - Kopie des aktuellen Profil Ordners zu erstellen.\n\nBestätigen?"
        if (confirm(confirmText)){ //copy folder only
            
            var srcPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            var destPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            try{
                srcPath.initWithPath(newProfilePath.path);
                destPath.initWithPath(gProfileINIArray[1][profileIndex]);
            }catch(e){
                alert("Der korrekte Pfad zum gesicherten Profil Ordner konnte nicht gefunden werden. Bitte den richtigen Pfad auswählen und nochmals versuchen.");
            }   
            
            if (srcPath.exists()){
                if (pm_checkProfileFolder(destPath)) destPath.remove(true);
                srcPath.copyTo(destPath.parent, destPath.leafName);
            }
        }
        break;
        
        case "restoreAll":
        confirmText = "Alle Profile und die profiles.ini Datei sichern, von: \n\n"+ newProfilePath.path + "\nDie aktuell existierenden Profile und die profiles.ini Datei werden überschrieben und können nicht wieder hergestellt werden. Bitte ziehen Sie in Betracht zuerst eine Sicherung - Kopie der aktuellen Profile und der profiles.ini Datei zu erstellen. \n\nDiese Operation verlangt einen Neustart von Firefox.\n\nBestätigen?"
        if (confirm(confirmText)){ //copy folder only
                                 
            var iniPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            iniPath.initWithPath(gProfileINIPath.path);
                        
            var srcPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            srcPath.initWithPath(newProfilePath.path);
            srcPath.append("profiles.ini");
                        
            if (srcPath.exists()){
                if (iniPath.exists()){
                    var profileINIArrayOld = pm_parseProfileINI();
                    iniPath.remove(false);
                }
                srcPath.copyTo(gProfileINIPath.parent, "profiles.ini");
             } else {
                alert("In diesem Ordner ist keine profiles.ini Datei vorhanden. Bitte wählen Sie den korrekten Pfad zum richtigen Speicherort der profiles.ini Datei.");
                return false;
            }
            
            for (i = 0; i < profileINIArrayOld[1].length; i++){
                var tempPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                tempPath.initWithPath(profileINIArrayOld[1][i]);
                try{
                    if (pm_checkProfileFolder(tempPath)) tempPath.remove(true);
                }catch(e){
                   // alert(e);
                }
            }
            
            profileINIArrayNew = pm_parseProfileINI();
            for (i = 0; i < profileINIArrayNew[1].length; i++){
                var destPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                destPath.initWithPath(profileINIArrayNew[1][i]);
                
                var sourcePath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                sourcePath.initWithPath(newProfilePath.path);
                sourcePath.append(profileINIArrayNew[0][i]);
                if (sourcePath.exists()){
                    pm_copyDir(sourcePath.path, destPath.path, 1) //copy without alert
                }
            }
            restartApp(true);
        } // end if (confirm...
        break;
    }// end of switch
    
    // write gProfileINIArray to profile.ini
    if ((flag != "restoreAll") && (flag != "restoreINI") && (flag != "NoChange")){
        var profileINI = "[General]\r\nStartWithLastProfile=1\r\n\r\n";

        for (i = 0; i < gProfileINIArray[0].length; i++){
            profileINI = profileINI + "[Profile"+ i +"]\r\n"+"Name=" + gProfileINIArray[0][i] + "\r\n"+"IsRelative=0\r\n"+"Path="+gProfileINIArray[1][i]+"\r\n";
            if (gProfileINIArray[0][i] == pmOptions.getCharPref("opt_defaultProfileName")) profileINI = profileINI + "Default=1\r\n";
            profileINI = profileINI + "\r\n";
        }
        //alert(profileINI);
        pm_writeProfileINI(profileINI, "overwrite");
    }
}// end of function makeChangesProfile

//load profile
function pm_loadProfile(){
        var installPath = Components.classes["@mozilla.org/file/directory_service;1"]
                                        .getService(Components.interfaces.nsIProperties)
                                        .get("CurProcD", Components.interfaces.nsIFile);
                                        
        var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                                    .getService(Components.interfaces.nsIXULAppInfo)
                                    .QueryInterface(Components.interfaces.nsIXULRuntime);
                                    
        var profileName = document.getElementById("pm_profileList").selectedItem.value;
        if (installPath != null) {
            
            if (appInfo.OS == "WINNT"){      
                installPath.append("firefox.exe");
            }
            else {
                installPath.append("firefox");
            } 
            
            var pmProcess = Components.classes["@mozilla.org/process/util;1"].getService(Components.interfaces.nsIProcess);
            try{
                pmProcess.init(installPath);
            }catch(e){;}
            pmArgs = ["-P", "-no-remote", profileName];
            pmProcess.run(false, pmArgs, pmArgs.length); 
        }
        else {
            alert("Fehler: Es wurde keine Mozilla Firefox Installation gefunden. ");
        }
}


// Code taken from chrome://toolkit/content/mozapps/extensions/extensions.js
// restart firefox
function restartApp(flag) {
  const nsIAppStartup = Components.interfaces.nsIAppStartup;
  
  if (flag == true){
      // Notify all windows that an application quit has been requested.
      var os = Components.classes["@mozilla.org/observer-service;1"]
      .getService(Components.interfaces.nsIObserverService);
      var cancelQuit = Components.classes["@mozilla.org/supports-PRBool;1"]
      .createInstance(Components.interfaces.nsISupportsPRBool);
      os.notifyObservers(cancelQuit, "quit-application-requested", null);
      
      // Something aborted the quit process. 
      if (cancelQuit.data)
      return;
      
      // Notify all windows that an application quit has been granted.
      os.notifyObservers(null, "quit-application-granted", null);
      
      // Enumerate all windows and call shutdown handlers
      var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
      .getService(Components.interfaces.nsIWindowMediator);
      var windows = wm.getEnumerator(null);
      while (windows.hasMoreElements()) {
          var win = windows.getNext();
          if (("tryToClose" in win) && !win.tryToClose())
          return;
      }
  }
  Components.classes["@mozilla.org/toolkit/app-startup;1"].getService(nsIAppStartup)
  .quit(nsIAppStartup.eRestart | nsIAppStartup.eAttemptQuit);
}

function pm_installToAll(){
    
    if (confirm ("Diese Erweiterung in alle in dieser Liste vorhandenen Profile installieren?")) {
        
        var extensionPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
        extensionPath.initWithPath(profDir.path);
        extensionPath.append("extensions");
        extensionPath.append("{69f6e5ea-e975-4d70-a983-1e5c094ded79}");
        
        for (i = 0; i < gProfileINIArray[0].length; i++){
            var destPath = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            destPath.initWithPath(gProfileINIArray[1][i]);
            destPath.append("extensions");
            if (!destPath.exists()) destPath.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0744);
            
            var tmpFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
            tmpFile.initWithPath(destPath.path);
            tmpFile.append("{69f6e5ea-e975-4d70-a983-1e5c094ded79}");
            if (!tmpFile.exists()) extensionPath.copyTo(destPath,"{69f6e5ea-e975-4d70-a983-1e5c094ded79}");
        }        
    }
}
