function OldLocationBar() {}

OldLocationBar.prototype = {

	observe: function(subject, topic, data)
	{
		if (topic == 'app-startup')
		{
			this.observerService = Components.classes['@mozilla.org/observer-service;1'].getService(Components.interfaces.nsIObserverService);
			this.observerService.addObserver(this, 'profile-after-change', false);
			this.observerService.addObserver(this, 'xpcom-shutdown', false);
		}
		else if (topic == 'profile-after-change')
		{
			var ioService = Components.classes['@mozilla.org/network/io-service;1'].getService(Components.interfaces.nsIIOService);
			var styleSheetService = Components.classes['@mozilla.org/content/style-sheet-service;1'].getService(Components.interfaces.nsIStyleSheetService);
			var prefBranch = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService).getBranch('extensions.OldLocationBar.');
			var prefs = prefBranch.getChildList('', {});
			for (var i = 0; i < prefs.length; i++)
			{
				if (prefBranch.getBoolPref(prefs[i]))
				{
					var sheet = ioService.newURI('chrome://OldLocationBar/skin/' + prefs[i] + '.css', null, null);
					styleSheetService.loadAndRegisterSheet(sheet, styleSheetService.AGENT_SHEET);
				}
			}
		}
		else if (topic == 'xpcom-shutdown')
		{
			this.observerService.removeObserver(this, 'profile-after-change');
			this.observerService.removeObserver(this, 'xpcom-shutdown');
			this.observerService = null;
		}
	},
	
	QueryInterface: function(iid)
	{
		if (iid.equals(Components.interfaces.nsIObserver) || iid.equals(Components.interfaces.nsISupports))
		{
			return this;
		}
		else
		{
			throw Components.results.NS_ERROR_NO_INTERFACE;
		}
	}
}

var OldLocationBarModuleFactory = {

	_NAME: 'OldLocationBar',
	
	_CID: Components.ID('{3205B348-523A-4fac-9BC4-9939CBF583B0}'),
	
	_CONTRACT_ID: 'kakkoii@email.com;1',
	
	_IMPLEMENTATION: OldLocationBar,
	
	registerSelf: function(compMgr, fileSpec, location, type)
	{
		compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
		compMgr.registerFactoryLocation(this._CID, this._NAME, this._CONTRACT_ID, fileSpec, location, type);
		
		var categoryManager = Components.classes['@mozilla.org/categorymanager;1'].getService(Components.interfaces.nsICategoryManager);
		categoryManager.addCategoryEntry('app-startup', this._NAME, 'service,' + this._CONTRACT_ID, true, true);
	},
	
	unregisterSelf: function(compMgr, fileSpec, location)
	{
		compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
		compMgr.unregisterFactoryLocation(this._CID, fileSpec);
		
		var categoryManager = Components.classes['@mozilla.org/categorymanager;1'].getService(Components.interfaces.nsICategoryManager);
		categoryManager.deleteCategoryEntry('app-startup', this._NAME, true);
	},
	
	getClassObject: function(compMgr, cid, iid)
	{
		if (!iid.equals(Components.interfaces.nsIFactory))
		{
			throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
		}
		
		if (cid.equals(this._CID))
		{
			return this;
		}
		else
		{
			throw Components.results.NS_ERROR_NO_INTERFACE;
		}
	},
	
	canUnload: function(compMgr)
	{
		return true;
	},
	
	createInstance: function(outer, iid)
	{
		if (outer)
		{
			throw Components.results.NS_ERROR_NO_AGGREGATION;
		}
		
		return (new this._IMPLEMENTATION()).QueryInterface(iid);
	}
};

function NSGetModule(compMgr, fileSpec)
{
	return OldLocationBarModuleFactory;
}