/*  HideTab extension for Mozilla/Firefox, version 1.7
*  (c) 2011 Diego Alejandro Ruiz diegoratt@gmail.com
/*--------------------------------------------------------------------------*/
if(!mozEx) var mozEx={};
if(!mozEx.diegoratt) mozEx.diegoratt={};
mozEx.diegoratt.hidetabPackage = function(){
	var pub = {};
	pub.initOverlay = function(){
		var container = gBrowser.tabContainer;
		container.addEventListener("TabSelect", function(){ pub.OnTabChange(); }, false);
	}

	pub.hidetabKeyboard = function(flag){
		if (flag==1)//hide actual tab
		{
			var tabs = getBrowser().mTabContainer.childNodes;
			for(var j = 0; j < tabs.length; j++)
			{
				if (tabs[j].selected==true)
				{
					pub.hideTabToogle(j);
					return null;
				}
			}
		}
		else if (flag==2)//hide all
		{
			pub.hideTabHideAll();
		}
		else //unhide all
		{
			pub.hideTabRestoreAll();
		}
	}

	pub.OnTabChange = function(){
		var tab = getBrowser().mContextTab;
		var tabs = getBrowser().mTabContainer.childNodes;
		var counter=null;
		for(var j = 0; j < tabs.length; j++)
		{
			if (tabs[j].selected==true && tabs[j].style.display=='none' )
			{
				gBrowser.selectedTab = gBrowser.tabContainer.childNodes[pub.hideTabNewTab(j)];
			}
		}
	}

	pub.updateTabPos = function(){
		var tab = getBrowser().mContextTab;
		var tabs = getBrowser().mTabContainer.childNodes;
		var counter=null;
		for(var j = 0; j < tabs.length; j++)
		{
			if ( tabs[j]==tab)
			{
				counter=j;
			}
		}
		mozEx.diegoratt.hidetabPackage.hideTabToogle(counter);
	}

	pub.updatePagePos = function(){
		var tab = gBrowser.selectedTab;
		var tabs = getBrowser().mTabContainer.childNodes;
		var counter=null;
		for(var j = 0; j < tabs.length; j++)
		{
			if ( tabs[j]==tab)
			{
				counter=j;
			}
		}
		mozEx.diegoratt.hidetabPackage.hideTabToogle(counter);
	}

	pub.openTabList = function(elem){
		var tabs = getBrowser().mTabContainer.childNodes;
		if (elem)
		{
			pytList = document.getElementById("contexthidetabtabslistitemstab");
		}
		else
		{
			pytList = document.getElementById("contexthidetabtabslistitems");
		}
		if(pytList.state == "open")
		{
			return true;
		}

		if(pytList.state == "showing")
		{
			var children = pytList.childNodes;
			var n = children.length;
			for (var i = 0; i < n; i++)
			{
				pytList.removeChild(children[0]);
			}
		}
		for(var i = 0; i < tabs.length; i++)
		{
			var newItem = document.createElement('menuitem');
			newItem.setAttribute("label", tabs[i].label);
			if (tabs[i].style.display=='none')
			{
				newItem.setAttribute("class", "menuitem-iconic");
				newItem.setAttribute("image","chrome://hidetab/content/images/exclamation.png");
			}
			newItem.setAttribute("oncommand", "mozEx.diegoratt.hidetabPackage.hideTabToogle("+i+");");
			pytList.appendChild(newItem);
		}
	}

	pub.hideTabRestoreAll = function(){
		var tabs = getBrowser().mTabContainer.childNodes;
		for(var i = 0; i < tabs.length; i++)
		{
			if ( tabs[i].style.display=='none' )
			{
				tabs[i].style.display='';
			}
		}
	}

	pub.hideTabHideAll = function(){
		var tabs = getBrowser().mTabContainer.childNodes;
		for(var i = 0; i < tabs.length; i++)
		{
			tabs[i].style.display='none';
		}
		var prefManager = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
		var homeType = prefManager.getBoolPref('extensions.hidetab.homePanicPage');
		if (homeType)
		{
			var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
			var branch = prefs.getBranch("browser.startup.");
			var home = branch.getComplexValue("homepage",Components.interfaces.nsIPrefLocalizedString).data;
		}
		else
		{
			var home = prefManager.getCharPref('extensions.hidetab.userPanicPage');
		}
		gBrowser.selectedTab = gBrowser.addTab(home);
		pub.hideTabRefreshIcon();
	}

	pub.hideTabNewTab = function(current){
		var tabs = getBrowser().mTabContainer.childNodes;
		var max=tabs.length;
		var pos=current;
		for(var j = 0; j < tabs.length; j++)
		{
			if ( tabs[j].style.display!='none' )
			{
				if ( Math.abs(current-j)<max )
				{
					max=Math.abs(current-j);
					pos=j;
				}
			}
		}
		return pos;
	}

	pub.hideTabToogle = function(number){
		var tabs = getBrowser().mTabContainer.childNodes;
		var counter=0;
		for(var j = 0; j < tabs.length; j++)
		{
			if ( tabs[j].style.display!='none' )
			{
				counter++;
			}
		}
		for(var i = 0; i < tabs.length; i++)
		{
			if ( i==number )
			{
				if ( tabs[i].style.display!='none' )
				{
					tabs[i].style.display='none';
					if (tabs[i].selected==true)
					{
						if (counter>1)
						{
							gBrowser.selectedTab = gBrowser.tabContainer.childNodes[pub.hideTabNewTab(i)];
						}
						else
						{
							pub.hideTabHideAll()
						}
					}
				}
				else
				{
					tabs[i].style.display='';
					gBrowser.selectedTab = gBrowser.tabContainer.childNodes[i];
				}
			}
		}
	}
	return pub;
}();
window.addEventListener("load", function() { mozEx.diegoratt.hidetabPackage.initOverlay(); }, false);