            const {Cu} = require('chrome');
            const _ = require('sdk/l10n').get;
            const actionbutton = require('sdk/ui/button/action');
            const prefs = require('sdk/preferences/service');
            const data = require('sdk/self').data;
             
            exports.main = function () {
                if (prefs.get('media.windows-media-foundation.enabled')) {
                  let icon18 = 'enabled-18.png';
                  let icon32 = 'enabled-32.png';
                  let icon36 = 'enabled-36.png';
                  let icon64 = 'enabled-64.png';
                } else {
                  let icon18 = 'disabled-18.png';
                  let icon32 = 'disabled-32.png';
                  let icon36 = 'disabled-36.png';
                  let icon64 = 'disabled-64.png';
                }
                actionbutton.ActionButton({
                    id: 'quickmediacodec',
                    label: _('LABEL_1'),
                    icon : {
                     '18' : data.url(this.icon18),
                     '32' : data.url(this.icon32),
                     '36' : data.url(this.icon36),
                     '64' : data.url(this.icon64)
            },
                    onClick: function() {
                        let appInfo = Cu.import('resource://gre/modules/Services.jsm').Services.appinfo;
                   let config1, config2;

                        if(appInfo.OS == 'Linux') {
                            config1 = 'media.gstreamer.enabled';
                            config2 = 'media.gstreamer.enabled';
                        }
                        else if(appInfo.OS == 'Darwin') {
                            config1 = 'media.apple.mp3.enabled';
                            config2 = 'media.apple.mp3.enabled';
                        }
                        else {
                            config1 = 'media.windows-media-foundation.enabled';
                            config2 = 'media.directshow.enabled';
                        }

                        if (false === prefs.get(config1)) {
                       prefs.set(config1, true);
                       prefs.set(config2, true);
                       this.icon = {
                          '18': data.url('enabled-18.png'),
                       }
                    } else {
                       prefs.set(config1, false);
                       prefs.set(config2, false);
                       this.icon = {
                          '18': data.url('disabled-18.png'),
                       }
                    }
                    } // onClick
                }); // ActionButton
            }; // main function
             
            exports.onUnload = function (reason) {
                if ('disable' === reason || 'uninstall' === reason) {
                    prefs.reset('media.windows-media-foundation.enabled');
                    prefs.reset('media.directshow.enabled');
                    prefs.reset('media.gstreamer.enabled');
                    prefs.reset('media.apple.mp3.enabled');
                }
            };